

"""
circseq_cup -- circular RNA analysis toolkits.

Usage: RunMe.py [options]

Options:
    -h --help                        Show this screen.
    --version                        Show version.
    -o PREFIX --output=PREFIX        Output prefix [default: circ].
    -t TYPE --type=TYPE              The type of upstream aligners.(tophat_fusion or others) [default: others].
    -f FILE --file=FILE              The input file the upstream aligner made.\
TopHat-Fusion fusion BAM file (used in TopHat-Fusion mapping) dir for tophat_fusion, \
the fusion site file for others.     
    -l LENGHT --length=LENGHT        The maximal length between candidate start and end [default: 5000].
    -r REF --ref=REF                 Gene annotation.
    -g GENOME --genome=GENOME        Genome FASTA file.    
    -1 FASTQ_1 --fastq_1=FASTQ_1     Reads1.(*.fastq or *.fastq.gz)
    -2 FASTQ_2 --fastq_2=FASTQ_2     Reads2.
"""

__author__ = 'Xingchen Zhang (zhangxc_bio@foxmail.com)'
__version__ = '1.0'

from docopt import docopt
import sys
import os


def check(x,comd):
    if 0!=x:
        sys.exit('%s failed !' % comd)


if __name__ == '__main__':
    if len(sys.argv) == 1:
        sys.exit(__doc__)
    options = docopt(__doc__, version=__version__)
    parameters = ('--file', '--ref', '--genome',  '--fastq_1', '--fastq_2')
    miss_parameters = []
    for arg in parameters:
        if not options[arg]:
            miss_parameters.append(arg)
    if miss_parameters:
        sys.exit('Miss required option: ' + ' '.join(miss_parameters))

    path=sys.path[0]
    prefix = options['--output']
    pre_type = options['--type']
    tophat_fusion_dir=options['--file']
    fusion_site_file=options['--file']
    ref_file=options['--ref']
    genome_fasta=options['--genome']
    fq_1=options['--fastq_1']
    fq_2=options['--fastq_2']
    site_range=options['--length']


    os.system("mkdir -p "+prefix+"_output/circ_index")
    if pre_type=="tophat_fusion":
       x=os.system("python "+path+"/get_candidate_site.py -f "+tophat_fusion_dir+"/accepted_hits.bam -g "+genome_fasta+" -o "+prefix+" -l "+site_range)
       check(x,"get_candidate_site.py")
    else:
       x=os.system("python "+path+"/get_candidate_site.py -j "+fusion_site_file+" -g "+genome_fasta+" -o "+prefix+" -l "+site_range)
       check(x,"get_candidate_site.py")
    x=os.system("bowtie2-build "+prefix+"_output/circ_index/"+prefix+"_circ_ref.fa "+prefix+"_output/circ_index/"+prefix+"_circ_ref")
    check(x,"bowtie2-build")
    x=os.system("tophat -p 8 -o "+prefix+"_output/circ_thout "+prefix+"_output/circ_index/"+prefix+"_circ_ref "+fq_1+" "+fq_2)
    check(x,"tophat")
    x=os.system("python "+path+"/pack_and_assemble.py  -f "+prefix+"_output/circ_thout/accepted_hits.bam -g "+genome_fasta+" -o "+prefix)
    check(x,"pack_and_assemble.py")
    x=os.system("python "+path+"/circ_anotation.py  -g  "+genome_fasta+" -r  "+ref_file+" -c "+prefix+"_output/cap3_circ_res -p "+prefix+"_output/"+prefix+"_reads_num -o "+prefix)
    check(x,"circ_anotation.py")
    x=os.system("perl "+path+"/circ_seq_statistics.pl "+prefix+"_output/"+prefix+"_res "+prefix+"_output/"+prefix+"_res_statistics.out")
    check(x,"circ_seq_statistics.pl")
    print "Finish!"